	subroutine INTERPOL1(Ns, Nxy, f, xy, vl, dx, x, BCv, ierror)
! 1D interpolation at all nodes of a boundary element face

! f is face
! s is species

	implicit none
	integer Ns, Nxy(0:4), f, i, k, ierror
	real*8 Xmin, Xmax, dx, x(2), tol
	real*8 xy(4,Nxy(0)), vl(4,Ns,Nxy(0)), Bcv(4,Ns,2)

	tol = dx * 1.d-6	! geometric tolerance

! linear interpolation for the 2 nodes
	do i = 1,2
	  do k = 1,Nxy(f)-1
	    if( x(i) .ge. xy(f,k)-tol .and. x(i) .le. xy(f,k+1)+tol ) then
! found - interpolate k interval
	      BCv(f,:,i) = vl(f,:,k) + ( x(i) - xy(f,k) ) * &
			( vl(f,:,k+1) - vl(f,:,k) ) / ( xy(f,k+1) - xy(f,k) )
	    endif
	  enddo		! k
	enddo		! i

	return
	end
